/* -*- Mode:C -*- */

/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1987,1988,1989,1990 Texas Instruments Incorporated.    */
/*  All rights reserved.                                                 */
/*                                                                       */


/*
 *  This file contains placebo definitions for types and functions that
 *  are defined by library and include files in the "Communication Toolbox"
 *  software package available from Apple Computer Inc.  
 *  These definitions are necessary to allow linking applications (ie
 *  rpc) with MX-LIB.O without requiring the "Communication Toolbox"
 *  software.
 *
 *  In order to link your application with the true connection manager
 *  routines in mx-LIB.O, you should do the following steps:
 *
 *   1.  Purchase and install the "Communication Toolbox" software package 
 *       from Apple Computer Inc.
 *     
 *   2.  Remove the #include <cmstubs.h> from your application source
 *       files.
 *
 *   3.  Link the Communication Toolbox library file CommToolbox.o with
 *       your application.
 */


#include <types.h>

/************ from file CMINTF.H ***********/

/* Dummy type declarations */

typedef struct {ignore} ConnRecord;

typedef struct {ignore} ConnEnvironRec;

typedef ConnRecord *ConnPtr, **ConnHandle;

typedef long  CMBufferSizes;

typedef short CMChannel;

typedef short CMFlags, CMStatFlags, CMRecFlags;

typedef short TMErr, FTErr, CTBUErr, CMErr, CRMErr;


/* Dummy function declarations */

pascal CMErr
CMGetConnEnvirons(ConnHandle hConn, ConnEnvironRec *theEnvirons)
{
#pragma unused (hConn, theEnvirons)
  return (CMErr) 0;
}

extern pascal void
CMDefault(Ptr *theConfig, short procID, Boolean allocate)
{
#pragma unused (theConfig, procID, allocate)
}

extern pascal Boolean 	
CMValidate(ConnHandle hConn)
{
#pragma unused (hConn)
  return TRUE;
}

extern pascal void 		
CMReset(ConnHandle hConn)
{
#pragma unused (hConn)
}

extern pascal CMErr 	
CMIOKill(ConnHandle hConn, short which)
{
#pragma unused (hConn, which)
  return (CMErr) 0;
}

extern pascal CMErr 	
CMListen(ConnHandle hConn, Boolean async, ProcPtr completor, long timeout)
{
#pragma unused (hConn, async, completor, timeout)
  return (CMErr) 0;
}

extern pascal CMErr 	
CMAccept(ConnHandle hConn, Boolean accept)
{
#pragma unused (hConn, accept)
  return (CMErr) 0;
}

extern pascal CMErr		
InitCM(void)
{
  return (CMErr) 0;
}

extern pascal void 		
CMIdle(ConnHandle hConn)
{
#pragma unused (hConn)
}

extern pascal CMErr 		
CMAbort(ConnHandle hConn)
{
#pragma unused (hConn)
  return (CMErr) 0;
}

extern pascal CMErr 	
CMStatus(ConnHandle hConn, CMBufferSizes sizes, CMStatFlags *flags)
{
#pragma unused (hConn, sizes, flags)
  return (CMErr) 0;
}

extern pascal ConnHandle	
CMNew(short procID, CMRecFlags flags, CMBufferSizes desiredSizes, 
				long refCon, long userData)
{
#pragma unused (procID, flags, desiredSizes, refCon, userData)
  return (ConnHandle) NULL;
}

extern pascal short 	
CMGetProcID(const Str255 name)
{
#pragma unused (name)
  return (short) 0;
}

extern pascal short 	
CMSetConfig(ConnHandle hConn, Ptr thePtr)
{
#pragma unused (hConn, thePtr)
  return (short) 0;
}

extern pascal Ptr 		
CMGetConfig(ConnHandle hConn)
{
#pragma unused (hConn)
  return (Ptr) NULL;
}

extern pascal CMErr 	
CMWrite(ConnHandle hConn, Ptr theBuffer, long *toWrite,
				CMChannel theChannel, Boolean async, ProcPtr completor, long timeout, 
				CMFlags flags)
{
#pragma unused (hConn, theBuffer, toWrite, theChannel, async, completor, timeout, flags)
  return (CMErr) 0;
}

extern pascal CMErr 	
CMOpen(ConnHandle hConn, Boolean async, ProcPtr completor, long timeout)
{
#pragma unused (hConn, async, completor, timeout)
  return (CMErr) 0;
}

extern pascal CMErr 	
CMRead(ConnHandle hConn, Ptr theBuffer, long *toRead, 
			       CMChannel theChannel, Boolean async, ProcPtr completor, long timeout, 
			       CMFlags *flags)
{
#pragma unused (hConn, theBuffer, toRead, theChannel, async, completor, timeout, flags)
  return (CMErr) 0;
}

extern pascal void 		
CMDispose(ConnHandle hConn)
{
#pragma unused (hConn)
}

extern pascal CMErr 	
CMClose(ConnHandle hConn, Boolean async, ProcPtr completor, long timeout, Boolean now)
{
#pragma unused (hConn, async, completor, timeout, now)
  return (CMErr) 0;
}

/************ from file CRMINTF.H ***********/ 

extern pascal CRMErr 	
InitCRM(void)
{
  return (CRMErr) 0;
}

/************ from file CTBUTILS.H ***********/

extern pascal CTBUErr	
InitCTBUtilities(void)
{
  return (CTBUErr) 0;
}

/************ from file FTINTF.H ***********/

extern pascal FTErr 	
InitFT(void)
{
  return (FTErr) 0;
}

/************ from file TMINTF.H ***********/

extern pascal TMErr 	
InitTM(void)
{
  return (TMErr) 0;
}

